local key = ModPath .. '	' .. RequiredScript
if _G[key] then return else _G[key] = true end

_G.Vanilla_HAAN = _G.Vanilla_HAAN or {}
Vanilla_HAAN._path = ModPath
Vanilla_HAAN._data_path = SavePath .. 'vanilla_haan.txt'
Vanilla_HAAN._data = {}
Vanilla_HAAN.settings = {}
Vanilla_HAAN.temp = {
	savestate = ""
}

function Vanilla_HAAN:reset()
	self.settings.savestate = os.date("%Y%m%d%H%M%S")
	-- for main player
	self.settings.m_only = false
	--health
	self.settings.mh_y = 6
	self.settings.mh_font_size = 20
	--armor
	self.settings.ma_y = -9
	self.settings.ma_font_size = 16

	-- for sec players
	--health
	self.settings.sh_y = 8
	self.settings.sh_font_size = 18
	--armor
	self.settings.sa_y = -7
	self.settings.sa_font_size = 16
end

function Vanilla_HAAN:settings_to_data()
	self._data.m_only = self.settings.m_only 
	self._data.mh_y = self.settings.mh_y
	self._data.mh_font_size = self.settings.mh_font_size
	self._data.ma_y = self.settings.ma_y
	self._data.ma_font_size = self.settings.ma_font_size

	self._data.sh_y = self.settings.sh_y
	self._data.sh_font_size = self.settings.sh_font_size
	self._data.sa_y = self.settings.sa_y
	self._data.sa_font_size = self.settings.sa_font_size
end

function Vanilla_HAAN:load()
	self:reset()
	local file = io.open(self._data_path, 'r')
	if file then
		for k, v in pairs(json.decode(file:read('*all')) or {}) do
			self.settings[k] = v
		end
		file:close()
	end
	self:settings_to_data()
end

function Vanilla_HAAN:save()
	self.settings.savestate = os.date("%Y%m%d%H%M%S")
	local file = io.open(self._data_path, 'w+')
	if file then
		file:write(json.encode(self.settings))
		file:close()
	end
end

-- INI: just for developers and curious
function Vanilla_HAAN:DebugEnabled() 
	return false
end

function Vanilla_HAAN:log(a,...)
	if not self:DebugEnabled() then 
		return
	end
	if Console then
		return Console:log(a,...)
	else
		return log("[Vanilla_HAAN] " .. tostring(a))
	end
end
-- END: just for developers and curious

Hooks:Add("LocalizationManagerPostInit", "LocalizationManagerPostInit_Vanilla_HAAN", function(loc)
	if file.DirectoryExists(Vanilla_HAAN._path .. "loc/") then
		for _, filename in pairs(file.GetFiles(Vanilla_HAAN._path .. "loc/")) do
			local str = filename:match('^(.*).json$')
			if str and Idstring(str) and Idstring(str):key() == SystemInfo:language():key() then
				loc:load_localization_file(Vanilla_HAAN._path .. "loc/" .. filename)
				break
			end
		end
	end
	loc:load_localization_file(Vanilla_HAAN._path .. "loc/english.json", false)
end)

Hooks:Add('MenuManagerInitialize', 'MenuManagerInitialize_Vanilla_HAAN', function(menu_manager)
	-- Main Only
	function MenuCallbackHandler:Vanilla_HAANsetMainOnly(item)
		Vanilla_HAAN.settings.m_only = item:value() == 'on' and true or false
	end
	-- Sliders Main
	function MenuCallbackHandler:Vanilla_HAANsetMainHealthY(item)
		Vanilla_HAAN.settings.mh_y = math.round(tonumber(item:value()))
	end
	function MenuCallbackHandler:Vanilla_HAANsetMainHealthFontSize(item)
		Vanilla_HAAN.settings.mh_font_size = math.round(tonumber(item:value()))
	end
	function MenuCallbackHandler:Vanilla_HAANsetMainArmorY(item)
		Vanilla_HAAN.settings.ma_y = math.round(tonumber(item:value()))
	end
	function MenuCallbackHandler:Vanilla_HAANsetMainArmorFontSize(item)
		Vanilla_HAAN.settings.ma_font_size = math.round(tonumber(item:value()))
	end

	-- Sliders Sec
	function MenuCallbackHandler:Vanilla_HAANsetSecHealthY(item)
		Vanilla_HAAN.settings.sh_y = math.round(tonumber(item:value()))
	end
	function MenuCallbackHandler:Vanilla_HAANsetSecHealthFontSize(item)
		Vanilla_HAAN.settings.sh_font_size = math.round(tonumber(item:value()))
	end
	function MenuCallbackHandler:Vanilla_HAANsetSecArmorY(item)
		Vanilla_HAAN.settings.sa_y = math.round(tonumber(item:value()))
	end
	function MenuCallbackHandler:Vanilla_HAANsetSecArmorFontSize(item)
		Vanilla_HAAN.settings.sa_font_size = math.round(tonumber(item:value()))
	end

	function MenuCallbackHandler:Vanilla_HAANreset(item)
		Vanilla_HAAN:reset()
		Vanilla_HAAN:settings_to_data()

		MenuHelper:ResetItemsToDefaultValue(item, {['vanilla_haan_main_only'] = true}, Vanilla_HAAN._data.m_only)

		MenuHelper:ResetItemsToDefaultValue(item, {['vanilla_haan_main_health_y'] = true}, Vanilla_HAAN._data.mh_y)
		MenuHelper:ResetItemsToDefaultValue(item, {['vanilla_haan_main_health_font_size'] = true}, Vanilla_HAAN._data.mh_font_size)
		MenuHelper:ResetItemsToDefaultValue(item, {['vanilla_haan_main_armor_y'] = true}, Vanilla_HAAN._data.ma_y)
		MenuHelper:ResetItemsToDefaultValue(item, {['vanilla_haan_main_armor_font_size'] = true}, Vanilla_HAAN._data.ma_font_size)

		MenuHelper:ResetItemsToDefaultValue(item, {['vanilla_haan_sec_health_y'] = true}, Vanilla_HAAN._data.sh_y)
		MenuHelper:ResetItemsToDefaultValue(item, {['vanilla_haan_sec_health_font_size'] = true}, Vanilla_HAAN._data.sh_font_size)
		MenuHelper:ResetItemsToDefaultValue(item, {['vanilla_haan_sec_armor_y'] = true}, Vanilla_HAAN._data.sa_y)
		MenuHelper:ResetItemsToDefaultValue(item, {['vanilla_haan_sec_armor_font_size'] = true}, Vanilla_HAAN._data.sa_font_size)

		Vanilla_HAAN:save()
	end

	function MenuCallbackHandler:Vanilla_HAANsave()
		Vanilla_HAAN:save()
	end

	Vanilla_HAAN:load()
	MenuHelper:LoadFromJsonFile(Vanilla_HAAN._path .. 'menu/options.txt', Vanilla_HAAN, Vanilla_HAAN._data)
end)
